/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.common;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.common.CommonAPI;
import journeymap.api.v2.common.IJourneyMapPlugin;
import journeymap.api.v2.common.JourneyMapPlugin;
import journeymap.api.v2.server.IServerAPI;
import journeymap.api.v2.server.IServerPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PluginHelper {
    public static final Logger LOGGER = LogManager.getLogger((String)"journeymap");
    public static final String PLUGIN_INTERFACE_NAME = IJourneyMapPlugin.class.getSimpleName();
    private final Map<String, IClientPlugin> clientPlugins = new HashMap<String, IClientPlugin>();
    private final Map<String, IServerPlugin> serverPlugins = new HashMap<String, IServerPlugin>();
    private boolean initialized;
    private static PluginHelper instance;

    public static PluginHelper getInstance() {
        if (instance == null) {
            instance = new PluginHelper();
        }
        return instance;
    }

    public void preInitPlugins(List<String> pluginList) {
        for (String className : pluginList) {
            try {
                String version;
                Class pluginClazz;
                Class<?> pluginClass = Class.forName(className);
                boolean legacyPlugin = pluginClass.isAnnotationPresent(journeymap.api.v2.client.JourneyMapPlugin.class);
                boolean pluginPresent = pluginClass.isAnnotationPresent(JourneyMapPlugin.class);
                Class clazz = pluginClazz = legacyPlugin ? journeymap.api.v2.client.JourneyMapPlugin.class : JourneyMapPlugin.class;
                if (legacyPlugin) {
                    annotationClass = pluginClass.getDeclaredAnnotation(journeymap.api.v2.client.JourneyMapPlugin.class);
                    version = annotationClass.apiVersion();
                } else {
                    annotationClass = pluginClass.getDeclaredAnnotation(JourneyMapPlugin.class);
                    version = annotationClass.apiVersion();
                }
                if (legacyPlugin || pluginPresent) {
                    if (!this.inVersionRange(version)) continue;
                    Class<IJourneyMapPlugin> interfaceImplClass = pluginClass.asSubclass(IJourneyMapPlugin.class);
                    IJourneyMapPlugin instance = interfaceImplClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    String modId = instance.getModId();
                    if (Strings.isNullOrEmpty((String)modId)) {
                        throw new Exception("JourneyMapPlugin.getModId() must return a non-empty, non-null value");
                    }
                    if (IClientPlugin.class.isAssignableFrom(pluginClass)) {
                        this.clientPlugins.put(modId, (IClientPlugin)instance);
                    } else if (IServerPlugin.class.isAssignableFrom(pluginClass)) {
                        this.serverPlugins.put(modId, (IServerPlugin)instance);
                    }
                    LOGGER.info("Found @{}: {}", (Object)pluginClazz.getSimpleName(), (Object)className);
                    if (!legacyPlugin) continue;
                    LOGGER.warn("The mod {} for plugin {} is using a deprecated annotation, please inform the plugin mod dev they need to update.", (Object)modId, (Object)className);
                    continue;
                }
                LOGGER.error("Found @{}: {}, but it is not annotated with {}", (Object)PLUGIN_INTERFACE_NAME, (Object)className, (Object)pluginClazz.getSimpleName());
            }
            catch (Exception e) {
                LOGGER.error("Found @{}: {}, but failed to instantiate it: {}", (Object)JourneyMapPlugin.class.getSimpleName(), (Object)className, (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public <T extends IJourneyMapPlugin> void initPlugins(CommonAPI api) {
        Map<Object, Object> plugins = new HashMap();
        if (api instanceof IClientAPI) {
            plugins = this.clientPlugins;
        } else if (api instanceof IServerAPI) {
            plugins = this.serverPlugins;
        }
        Iterator<Object> iter = plugins.keySet().iterator();
        while (iter.hasNext()) {
            String modId = (String)iter.next();
            IJourneyMapPlugin plugin = (IJourneyMapPlugin)plugins.get(modId);
            try {
                plugin.initialize(api);
                LOGGER.info("Initialized {} as:{}: for:{}", (Object)PLUGIN_INTERFACE_NAME, (Object)plugin.getClass().getName(), (Object)modId);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize IJourneyMapPlugin: {} for Mod: {}", (Object)plugin.getClass().getName(), (Object)modId, (Object)e);
                iter.remove();
            }
        }
    }

    boolean inVersionRange(String pluginApiVersion) {
        return true;
    }

    public Map<String, IClientPlugin> getClientPlugins() {
        return this.clientPlugins;
    }

    public Map<String, IServerPlugin> getServerPlugins() {
        return this.serverPlugins;
    }
}

